<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Categorias</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Inicio</a></li>
                    <li class="breadcrumb-item active">Administrar Categorias </li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<!-- Main content -->
<div class="content">
    <div class="container-fluid">
           <!-- row para criterio de busqueda -->
            <div class="row">
               
            </div>
            <!-- row para criterio de busqueda -->
            <div class="row">
                <div class="col-lg-12">
                    <table id="tbl_Categorias" class="table table-striped w-100">
                        <thead class="bg-info">
                            <tr>
                                <th></th>
                                <th>Id</th>
                                <th>Categoria</th>
                                <th>Aplica Peso</th>
                                <th>Fecha Creación</th>
                                <th>Fecha Actualización</th>
                                <th class="text-center">Opciones</th>
                            </tr>
                        </thead>
                        <tbody class="text-small">
                        </tbody>
                    </table>
                </div>
            </div>
    </div><!-- /.container-fluid -->
</div>
<!-- /.content -->

<!-- Ventana modal para ingresar o modificar un producto -->
<div class="modal fade" id="mdlGestionarCategoria" role="dialog">
    <div class="modal-dialog modal-lg">

        <!-- contenido del modal -->
        <div class="modal-content">

            <!-- cabecera del modal -->
            <div class="modal-header bg-gray py-1 align-items-center">
                <h5 class="modal-title">Agregar Categoria </h5>
                <button type="button" class="btn btn-outline-primary text-white border-0 fs-5" data-bs-dismiss="modal" id="btnCerrarModal">
                        <i class="far fa-times-circle"></i>
                </button>
            </div>
            <!-- cuerpo del modal -->
            <div class="modal-body">

                <form class="needs-validation" novalidate>
                     <!-- abrimos una fila -->
                    <div class="row">

                        <!-- Columna para registro del codigo de categoria -->

                     
                        <!-- Columna para registro de la descripcion de categoria -->
                        <div class="col-12">
                            <div  class="form-group mb-2">
                                <label 
                                    class="" 
                                    for="iptDescripcionReg">
                                    <i
                                        class="fas fa-file-signature fs-6">
                                    </i>
                                    <span class="small">Descripción</span
                                    ><span class="text-danger">*</span></label>
                                <input 
                                    type="text" 
                                    class="form-control from-control-sm" 
                                    id="iptDescripcionReg"
                                    placeholder="Descripción"
                                    required>
                                <div class="invalid-feedback">Debe ingresar la descripción de la categoria</div>
                            </div>
                        </div>

                       <!-- Columna para registro del aplica-peso -->
                       <div class="col-lg-12">
                            <div  class="form-group mb-2">
                                <label class="" for="selAplicaPesoReg"><i class="fas fa-dumpster fs-6"></i>
                                    <span class="small">Aplica Peso</span>
                                    <span class="text-danger">*</span>
                                </label>
                                       <select 
                                        class="form-select from-select-sm" 
                                        aria-label=".form-select-sm example"
                                        id="selAplicaPesoReg"
                                        required>
                                        <option selected value="0">No</option>
                                       <option selected value="1">Si</option>
                                       </select>
                                      
                                <div class="invalid-feedback">Debe seleccionar si aplica peso o no</div>
                            </div>
                        </div>

                      

                        <button 
                            type="button" 
                            class="btn btn-danger mt-3 mx-2" 
                            style="width:170px;"
                            data-bs-dismiss = "modal" 
                            id="btnCancelarRegistro">Cancelar
                        </button>
                        <!-- data-bs-dismiss="modal" -->
                        <button 
                            type="button" 
                            style="width:170px;" 
                            class="btn btn-primary mt-3 mx-2" 
                            id="btnGuardarProducto" 
                            >Guardar Producto
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



<script>
     var accion=2;
     var table;
    
     var id_categoria = 0; // permitir definir si vamos a sumar o restar al stock(1:sumar, 2:restar)
    /* =================================================================================
     INICIALIZAMOS EL MENSAJE DE TIPO TOAST (EMERGENTE EN LA PARTE SUPERIOR)
    ================================================================================= */    
     var Toast= Swal.mixin({
         toast      :true,
         position   :'top',
         showConfirmButton:false,
         timer      :3000
     });

    $(document).ready(function(){
            $.ajax({
                url: "ajax/categorias.ajax.php",
                type:"POST",
                data:{'accion':2}, //1=listar productos (datos)
                dataType:'json',
                success:function(respuesta){
                   // console.log("ACCION -> ", accion);
                }
            });

    
            /* **********************************************************
            * CARGA DEL LISTADO CON EL PLUGIN DATATABLE JS
            ************************************************************ */
            table = $("#tbl_Categorias").DataTable({
                dom:'Bfrtip',
                buttons:[
                    {
                        text:'Agregar Categoria',
                        className:'addNewRecord',
                        action:function(e,dt,mode,config){
                            //evento para levantar el modal de insrtar //alert("nuevo boton");
                            $("#mdlGestionarCategoria").modal('show');
                            accion=3;//registrar
                        }
                    },
                    'excel','print','pageLength'
                ],
                pageLength:[5,10,15,30,50,100],
                pageLength:10,
                ajax:{
                    url: "ajax/categorias.ajax.php",
                    dataSrc:'',
                    type:"POST",
                    data:{'accion' : 2} //2=listar cATEGORIAS
                },
                responsive:{
                   details:{ type:'column' }
                },
                columnDefs:[
                    {
                        targets:0,
                        orderable:true,
                        className: 'control'
                    },
                    {
                        targets:6,
                        orderable:false,
                        render: function(data, type, meta){
                            return "<center>" +
                                        "<span class='btnEditarCategoria text-primary px-1' style='cursor:pointer;'>" +
                                            "<i class='fas fa-pencil-alt fs-5'></i>" +
                                        "</span>" +
                                       "<span class='btnEliminarCategoria text-danger px-1' style='cursor:pointer;'>" +
                                            "<i class='fas fa-trash-alt fs-5'></i>" +
                                        "</span>" + 
                                   "</center>"
                        }
                    }
                ],
                language:{
                    url:"//cdn.datatables.net/plug-ins/1.10.20/i18n/Spanish.json"
                }
            });
        
        /* ****************************************************************************
               EVENTO PARA LIMPIAR  INPUTS DE CRISTERIOS DE BUSQUEDA
        **************************************************************************** */
        
           $("#btnCancelarRegistro, #btnCerrarModal").on('click',function(){

               //$("#validate_codigo").css("display","none");
               $("#validate_descripcion").css("display","none"); 
               $("#validate_aplica_peso").css("display","none");  
                          
               //$("#iptCodigoReg").val("");
               $("#iptDescripcionReg").val("");
               $("#selAplicaPesoReg").val(0);
               
              
              // table.search('').columns().search('').draw();
           })

        /* **************************************************************************** 
          * EVENTO AL DAR CLICK EN EL BOTON EDITAR
         **************************************************************************** */
        $('#tbl_Categorias tbody').on('click','.btnEditarCategoria',function(){
            accion=4; //editar productos
           
            $("#mdlGestionarCategoria").modal('show');

            var data = table.row($(this).parents('tr')).data();
             id_categoria = data["id_categoria"];
            
            //console.log("~ file: productos.php ~ line 751 ~ $ ~ data", data);

           // $("#iptCodigoReg").val(data["id_ctegoria"]);//0
            $("#iptDescripcionReg").val(data[2]);
            
            var AP;
            //APLICA PESO?
            console.log(data[3]);
            if(data[3].equals("Si")){ 
                AP=1;
            } else{
                AP=0;
            } 
            $("#selAplicaPesoReg").val(AP);
            
                      
          
        
        })

        /* **************************************************************************** 
          * EVENTO AL DAR CLICK EN EL BOTON ELIMINAR
        **************************************************************************** */
        $('#tbl_Categorias tbody').on('click','.btnEliminarCategoria',function(){
            accion=5;//ELIMINAR

            var data = table.row($(this).parents('tr')).data();
             id_categoria = data["id_categoria"];

            Swal.fire({
                        title : 'Estas seguro de eliminar la categoria?',
                        icon : 'warning',
                        showCancelButton : true,
                        confirmButtonColor : '#3085d6',
                        cancelButtonColor : '#d33',
                        confirmButtonText : 'Si, deseo registralo!',
                        cancelButtonText : 'Cancelar',
                        }).then((result) => {
                                //console.log("En el formSubmitClick--> " + result);
                                if(result.isConfirmed){

                                    //console.log("En el formSubmitClick--> " + result.isConfirmed);
                                    var datos = new FormData();
                                    //console.log("En el DATOS--> " + datos);
                                    datos.append("accion", accion);
                                    datos.append("id_categoria", id_categoria);

                                    $.ajax({
                                            url         :"ajax/categorias.ajax.php",
                                            method      : "POST",
                                            data        : datos,
                                            cache       : false,
                                            contentType : false,
                                            processData : false,
                                            dataType    : 'json',
                                            success: function(respuesta){
                                               // console.log("respuesta", respuesta)
                                                
                                                    if (respuesta == "ok"){
                                                        Toast.fire({
                                                            icon    :   'success',
                                                            title   :   'La categoria se eliminó correctamente'
                                                        });
                                                        table.ajax.reload();
                                                    }else{
                                                        Toast.fire({
                                                            icon:'error',
                                                            title:'La categoria no se pudo eliminar'
                                                        });
                                                        //console.log(respuesta);
                                                    }

                                            }
                                        })

                                    }
                                }

                            )



        })
    })

   
    document.getElementById("btnGuardarProducto").addEventListener("click",function(){
        var forms = document.getElementsByClassName('needs-validation');

        var validation = Array.prototype.filter.call(forms, function(form){

            if (form.checkValidity() === true ){
               // console.log("Listo para registrar el producto");

                //validar ingresos de los campos o inputs
                Swal.fire({
                        title : 'Estas seguro de registrar la categoria?',
                        icon : 'warning',
                        showCancelButton : true,
                        confirmButtonColor : '#3085d6',
                        cancelButtonColor : '#d33',
                        confirmButtonText : 'Si, deseo registralo!',
                        cancelButtonText : 'Cancelar',
                    }).then((result) => {
                                //console.log("En el formSubmitClick--> " + result);
                                if(result.isConfirmed){

                                    //console.log("En el formSubmitClick--> " + result.isConfirmed);
                                    
                                    var AP=0;
                                    if($("#selAplicaPesoReg").val()=='Si'){ 
                                        AP=1;
                                    } else{
                                        AP=0;
                                    } 
                                                                     
                                    
                                    var datos = new FormData();

                                    //console.log("En el DATOS--> " + datos);
                                    datos.append("accion", accion);
                                    datos.append("id_categoria", id_categoria);
                                    datos.append("nombre_categoria",$("#iptDescripcionReg").val());
                                    datos.append("aplica_peso",AP);
                                  
                                   
                                    if (accion=3){
                                        var titulo_msg="La categoria se registró correctamente";
                                    }
                                    if (accion=4){
                                        var titulo_msg="La categoria se actualizó correctamente";
                                    }

                                    $.ajax({
                                            url         :"ajax/categorias.ajax.php",
                                            method      : "POST",
                                            data        : datos,
                                            cache       : false,
                                            contentType : false,
                                            processData : false,
                                            dataType    : 'json',
                                            success: function(respuesta){
                                               // console.log("respuesta", respuesta)
                                                
                                                    if (respuesta == "ok"){
                                                        Toast.fire({
                                                            icon    :   'success',
                                                            title   :   titulo_msg
                                                        });

                                                        table.ajax.reload();

                                                        $("#mdlGestionarCategoria").modal('hide');

                                                        //$("#iptCodigoReg").val("");
                                                        $("#iptDescripcionReg").val("");
                                                        $("#selAplicaPesoReg").val(0);
                                                     
                                                    }else{
                                                        Toast.fire({
                                                            icon:'error',
                                                            title:'El producto no se pudo registar'
                                                        });
                                                        //console.log(respuesta);
                                                    }

                                            }
                                        })

                                    }
                                }

                            )

            }else{
                console.log("No pasó la validación");
            }

            form.classList.add('was-validated');

        });
    })

    document.getElementById("btnCancelarRegistro").addEventListener("click",function(){
       $(".needs-validation").removeClass("was-validated");
    })

</script>