  <!-- Content Wrapper. Contains page content -->
  
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Reporte de asistencia  </h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">DataTables</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
  </section>
  
<!--Ejemplo tabla con DataTables-->
<section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
               <div class="card">
                   <div class="card-header">  <!-- /.card-header -->
                         <h3 class="card-title">Fecha: <?php echo " " . date("d") . "/" . date("m") . "/" . date("Y"); ?></h3>
                    </div> 
                    <div class="card-body"> <!-- /.card-header -->
                        <div class="table-responsive">  
                                  <table id="tblAsistencia" name="tblAsistencia" class="table table-striped table-bordered table-hover" cellspacing="0" width="100%">
                                      <thead>
                                            <tr>
                        				        	   	<th></th>
                                    					<th>ID</th>
                                    					<th>FECHA</th>
                                    					<th>DNI - ESTUDIANTE</th>
                                    					<th>G/S</th>
                                    					<th>INGRESO</th>
                                    					<th>SALIDA</th>
                                    					<th>E</th>
                                    					<th>T</th>
                                    					<th>OBSERVACION</th>
                                    					<th class="text-center"></th>
                                    					<th>RI</th>
                                    					<th>RS</th>
                                             </tr>
                                      </thead>
                                  <tbody>
                                                   
                                  </tbody>        
                              </table>
                      </div>
                  </div>
            </div> <!-- card -->
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div> <!-- /.container-fluid -->
</section>

<!-- modal para ingresar la observacion -- mdlGestionarStock --> 
<div class="modal fade" id="mdlObservacion" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            
            <div class="modal-header bg-gray py-2">
                <h6 class="modal-title" id="titulo_modal_stock">REGISTRAR OBSERVACIÓN</h6>
                <button 
                    type="button" 
                    class="btn btn-close text-white fs-6" 
                    data-bs-dismiss="modal" 
                    aria-label="Close"
                    id="btnCerrarModalStock">
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                        <div class="col-12 mb-3">
                        <label for="" class="form-label text-primary d-block">DNI: <span id="dni" 
                        class="text-secondary"></span></label>

                        <label for="" class="form-label text-primary d-block">Estudiante: <span id="estudiante" 
                        class="text-secondary"></span></label>
                        
                        <label for="" class="form-label text-primary d-block">Grado/Sección: <span id="grado_seccion" 
                        class="text-secondary"></span></label>
                        </div>

                        
                        <div class="col-lg-12">
                            <div  class="form-group mb-2">
                                <label class="" for="selMotivo"><i class="fas fa-dumpster fs-6"></i>
                                    <span class="small">Estados de asistencia</span>
                                    <span class="text-danger">*</span>
                                </label>
                                <select 
                                    class="form-select from-select-sm" 
                                    aria-label=".form-select-sm example"
                                    id="selMotivo"
                                    name="selMotivo"
                                    required>
                                </select>
                                <div class="invalid-feedback">Debe ingresar la categoria del productos</div>
                            </div>
                        </div>
                        
                        <div class="col-lg-12">
                            <div  class="form-group mb-2">
                                <label class="" for="selTipo"><i class="fas fa-dumpster fs-6"></i>
                                    <span class="small">Tipo se asistencia</span>
                                    <span class="text-danger">*</span>
                                </label>
                                <select 
                                    class="form-select from-select-sm" 
                                    aria-label=".form-select-sm example"
                                    id="selTipo"
                                    name="selTipo"
                                    required>
                                </select>
                                <div class="invalid-feedback">Seleccione el tipo</div>
                            </div>
                        </div>


                      <div class="col-lg-12">
                            <div  class="form-group mb-2">
                                <label 
                                    class="" 
                                    for="iptCodigoReg"><i class="fas fa-barcode fs-6"></i>
                                    <span class="small">Observacion</span>
                                    <span class="text-danger">*</span>
                                </label>
                              
                                <textarea 
                                      id="iptObservacion"
                                      class="form-control from-control-sm" 
                                      aria-label="With textarea"  
                                      placeholder="Ingrese la observación"
                                      required></textarea>
                                <div class="invalid-feedback">
                                    Debe ingresar la observacion
                                </div>
                            </div>
                        </div>
                        
                       
                </div>

            </div>
            <div class="modal-footer">
                    <button 
                            type="button" 
                            class="btn btn-secondary btn-sm" 
                            data-bs-dismiss = "modal" 
                            id="btnCancelarRegistroStock">Cancelar
                    </button>
                        <!-- data-bs-dismiss="modal" -->
                    <button 
                            type="button" 
                            class="btn btn-primary btn-sm" 
                            id="btnGuardarObservacion" 
                            >Guardar
                    </button>
            </div>

        </div>
    </div>

</div>

<script>
    /* var Toast=Swal.mixin({
      toast: true,
      position: 'top',
      showConfirmButton:false,
      timer:3000
    });*/
    
   
    $(document).ready(function(){
        var idAsistencia=0;
        var observacion="";
       // var medida="";
        var accion=0;
        
           //SOLICIUD AJAX PARA CARGAR SELECT DE CATEGORIAS
           $.ajax({
                url: "ajax/otros.ajax.php",
                type:"POST",
                data:{"accion":1}, //1=listar productos (datos)
                cache:false,
                contentType:false,
                processData:false,
                dataType:'json',
                success:function(respuesta){
                    var options='<option selected value="">Seleccione un Estado</option>';

                    for(let index=0; index < respuesta.length; index++){
                        options = options + '<option value=' + respuesta[index][0] + '>' + respuesta[index][1] +'</option>';
                    }
                    $('#selMotivo').html(options);  
                }
            });
            
            $.ajax({
                url: "ajax/otros.ajax.php",
                type:"POST",
                data:{"accion":2}, //1=listar productos (datos)
                cache:false,
                contentType:false,
                processData:false,
                dataType:'json',
                success:function(respuesta){
                    var options='<option selected value="">Seleccione un Tipo</option>';

                    for(let index=0; index < respuesta.length; index++){
                        options = options + '<option value=' + respuesta[index][0] + '>' + respuesta[index][1] +'</option>';
                    }
                    $('#selTipo').html(options);
                }
            });


        var tableAsistencia=$('#tblAsistencia').DataTable({
            dom: 'Bfrtip',
            buttons:[
                    'excel','print','pageLength'
            ],
            ajax:{
                url: "ajax/asistenciaAlu.ajax.php",
                dataSrc:'',
                type:"POST",
                data:{'accion':4 } //2=listar ASSITENCIAS DE HOY
               },
            columnDefs:[
                        {
                          targets:0,
                          orderable:false,
                          visible:false,
                          className: 'control'
                        },
                        {
                          targets:1,
                          orderable:false,
                          visible:false
                        },
                                    {
                                      targets:5,
                                      orderable:false,
                                        createdCell: function(td, cellData, rowData, row, col){
                                           var hora1 = new Date(rowData[1] + ' ' + rowData[2]);//'1/1/1990 06:07'); //obtenerMinutos(rowData[2]);
                                           var hora15 = new Date(rowData[1] + ' ' + '7:30 am');
                                           var hora30 = new Date(rowData[1] + ' ' + '7:40 am');
                                           
                                           if (hora1 <=hora15 ){
                                              $(td).parent().css('color','#110EB8');
                                           }else if (hora1 <=hora30 ){
                                            $(td).parent().css('color','#0BA239');
                                           }else if (hora1 > hora30 ){
                                            $(td).parent().css('color','#FF5700');
                                           }
                                           //console.log(rowData[2] + ' ' + horaLimite2 + ' ' + horaLimite );
                                        }
                                    },
                                    {
                                        targets:10,
                                        visible:true,
                                        orderable:false,
                                        render: function(data, type, meta){
                                            return "<center>" +
                                                    "<span class='btnObservacion text-primary px-1' style='cursor:pointer;'>" +
                                                            "<i class='fas fa-pencil-alt fs-5'></i>" +
                                                        "</span>" +
                                                    "</center>"
                                        }
                                    },
                                    {
                                        targets:11,
                                        visible:false
                                    },
                                    {
                                        targets:12,
                                        visible:false
                                    }
            ],
            "order":[[0,'desc']],
            lengthMenu:[5,10,15,20,50,100,200,300,500],
            pageLength:10,
            "language": {"url":"vistas/assets/dist/Spanish.json"}
        });
        
        $('#tblAsistencia tbody').on('click','.btnObservacion',function(){
            var data= tableAsistencia.row($(this).parents('tr')).data();
            
            if($(this).parents('tr').hasClass('selected')){
                $(this).parents('tr').removeClass('selected');
                idAsistencia=0;
                accion=0;
               // $("#iptCategoria").val("");
               // $("#selMedida").val("");
            }else{
                tableAsistencia.$('tr.selected').removeClass('selected');
                $(this).parents('tr').addClass('selected');
                accion=0;
                idAsistencia=data[1];
                
                var alu = data[3].split("-");// cadena.split([separador][,limite])
                
               
               var data = table.row($(this).parents('tr')).data();
              
               $("#mdlObservacion").modal('show');
              //alert(data[5]);
              $("#dni").html(alu[0]); 
              $("#estudiante").html(alu[1]);
              $("#grado_seccion").html(data[4]); 
              $("#iptObservacion").html(data[9]);
               //alert(idAsistencia);
            //console.log("~ file: productos.php ~ line 751 ~ $ ~ data", data);
            }
        
        });
        
        $("#btnCancelarRegistro, #btnCerrarModal").on('click',function(){

          /*  $("#validate_codigo").css("display","none");
            $("#validate_categoria").css("display","none"); 
            $("#validate_descripcion").css("display","none");  
            $("#validate_precio_compra").css("display","none"); 
            $("#validate_precio_venta").css("display","none"); 
            $("#validate_stock").css("display","none"); 
            $("#validate_min_stock").css("display","none"); 
            
            
            $("#iptCodigoReg").val("");
            $("#selCategoriaReg").val(0);
            $("#iptDescripcionReg").val("");
            $("#iptPrecioCompraReg").val("");
            $("#iptPrecioVentaReg").val("");
            $("#iptUtilidadReg").val("");
            $("#iptStockReg").val("");
            $("#iptMinimoStockReg").val(""); */
        
        // table.search('').columns().search('').draw();
        })
        
            
        
    })
</script>