<?php
	require_once 'conexion.php';

	class AsistenciaAluModelo{

	


	  static public function mdlCrearAsistenciaDelDia($fecha){

    		$stmt= Conexion::conectar()->prepare('CALL spCrearAsistencia(:FECHA)');
    		$stmt->bindParam(":FECHA", $fecha, PDO::PARAM_STR);

            if ($stmt -> execute()){
            	// return $stmt->fetch();
                $resultado = $stmt->fetch();//'ok';
            }else{
               $resultado = 'Error al actualizar el stock';
            }
   		
   		    $stmt = null;
        	return $resultado;   	
    	}

    	 static public function mdlActualizarAsistencia($FECHA, $HORA, $DNI_ALU, $ESTADO, $xTIPO_ASISTENCIA,  $OBSERVACION){
               // CALL sp_actualizaAsistencia
    	 	$stmt= Conexion::conectar()->prepare('select f_actualizaAsistencia(:FECHA, 
    	 																      :HORA, 
    	 																      :DNI_ALU,
    	 																      :ESTADO,
    	 																      :xTIPO_ASISTENCIA,
    	 																      :OBSERVACION)');

    		$stmt->bindParam(":FECHA", $FECHA, PDO::PARAM_STR);
    		$stmt->bindParam(":HORA", $HORA, PDO::PARAM_STR);
    		$stmt->bindParam(":DNI_ALU", $DNI_ALU, PDO::PARAM_STR);
    		$stmt->bindParam(":ESTADO", $ESTADO, PDO::PARAM_STR);
    		$stmt->bindParam(":xTIPO_ASISTENCIA", $xTIPO_ASISTENCIA, PDO::PARAM_STR);
    		$stmt->bindParam(":OBSERVACION", $OBSERVACION, PDO::PARAM_STR);

            if($stmt->execute()){
            	// return $stmt->fetch();
                return $stmt->fetch();//'ok';
            }else{
               return  Conexion::conectar()-> errorInfo();
            }
   		
   		    $stmt = null;
        	//return $resultado;   	

    	 }




    	 static public function mdlActualizarInformacion($table, $data, $id, $nameId){
	        $set="";

	        foreach ( $data as $key => $value){

	            $set .= $key ."= :".$key.","; 

	        }

	        $set=substr($set, 0, -1);

	        $stmt = Conexion::conectar()->prepare("UPDATE $table SET $set WHERE $nameId = :$nameId");

	        foreach ($data as $key => $value) {
	           $stmt ->bindParam(":".$key, $data[$key], PDO::PARAM_STR);
	        }

	        $stmt -> bindParam(":".$nameId, $id,PDO::PARAM_INT);

	        if($stmt->execute()){
	            return "ok"; //"Se realizó la actualización de forma exitosa";
	        }else{
	           return Conexion::conectar()-> errorInfo();
	        }
    	}


    	static public function mdlListar($FECHA, $ESTADO){

    		$stmt = Conexion::conectar()->prepare("SELECT  a.IDASISTENCIA_ALU AS ID,
														   a.FECHA,
														   a.HORA_ING,
														   a.HORA_SAL,
														   a.DNI_ALU AS DNI,
															(SELECT CONCAT(e.APE_PAT, ' ', e.APE_MAT, ', ', e.NOMBRES) AS NOM FROM estudiante e WHERE e.IDESTUDIANTE = a.COD_ALU) AS 'ESTUDIANTE',
															CONCAT( (SELECT g.NCORTO FROM grado g WHERE g.IDGRADO = a.CODGRADO) ,' ',
															(SELECT s.DESCRIPCION FROM seccion s WHERE s.IDSECCION = a.CODSECC)) AS 'GRA/SEC',
															IF (a.ESTADO=0,'F',IF(a.ESTADO=1,'J','A')) AS EST,
															IF (a.TIPO_ASISTENCIA=1,'T','P') AS TA,
															'' as OBSERVACIONES,
															'' as OPC
													FROM  asistencia_alu a
													WHERE (a.FECHA=:FECHA AND a.ESTADO=:ESTADO) ORDER BY a.IDASISTENCIA_ALU DESC") ;

    		$stmt->bindParam(":FECHA", $FECHA, PDO::PARAM_STR);
    		$stmt->bindParam(":ESTADO", $ESTADO, PDO::PARAM_STR);

    		$stmt->execute();
         return $stmt->fetchAll();//'ok';

    	}


    	static public function mdlListarHoy(){

    		$stmt = Conexion::conectar()->prepare("CALL sp_rptAsistenciasHOY();") ;
/*
    		$stmt->bindParam(":FECHA", $FECHA, PDO::PARAM_STR);
    		$stmt->bindParam(":ESTADO", $ESTADO, PDO::PARAM_STR);
*/
    		$stmt->execute();
         return $stmt->fetchAll();//'ok';

    	}
    	
    /* =================================================================
        buscar  PRODUCTOS POR CODIGO DE BARRAS 
    ==================================================================*/
    static public function   mdlListarNombreEstudiante(){
    
		$stmt = conexion::conectar()->prepare("SELECT CONCAT(NUM_DOC,' - ',APE_PAT, ' ',APE_MAT,' ', NOMBRES) AS NOMBRES 
												FROM estudiante");
		
		//$stmt ->bindParam(":codigoProducto", $codigo_producto, PDO::PARAM_INT);
		$stmt->execute();
		
		return $stmt->fetch(PDO::FETCH_OBJ);
    }
}